// This file must be loaded in the toolbar document.

function ToolbarAPI()
{
	this._winRef = window;
	this.events = new EventsObject(); // an empty EventsObject is created by default
}
ToolbarAPI.prototype.setProperty = ToolbarAPISetProperty;
ToolbarAPI.prototype.getProperty = ToolbarAPIGetProperty;
ToolbarAPI.prototype.setVar = ToolbarAPISetVar;
ToolbarAPI.prototype.getVar = ToolbarAPIGetVar;
ToolbarAPI.prototype.executeMethod = ToolbarAPIExecuteMethod;
ToolbarAPI.prototype.persistData = ToolbarAPIPersistData;
ToolbarAPI.prototype.registerEvent = ToolbarAPIRegisterEvent;
ToolbarAPI.prototype.raiseEvent = ToolbarAPIRaiseEvent;
ToolbarAPI.prototype.unregisterEvent = ToolbarAPIUnregisterEvent;

function ToolbarAPIRaiseEvent(strEvent)
{
	return this.events.raiseEvent(strEvent);
}

function ToolbarAPIRegisterEvent(strEvent, strEvtHandler, evtContext)
{
	var callbackId = this.events.registerEvent(strEvent, strEvtHandler, evtContext, true);
	return callbackId;
}

function ToolbarAPIUnregisterEvent(callbackId)
{
	return this.events.unregisterEvent(callbackId);
}

function ToolbarAPISetVar(varName, varVal)
{
	return this._winRef.handleSetVar(varName, varVal + "");
}

function ToolbarAPIGetVar(varName)
{
	return this._winRef.handleGetVar(varName);
}

function ToolbarAPISetProperty(propName, propVal)
{
	switch (propName.toLowerCase())
	{
		default:
			return this._winRef.handleSetProperty(propName.toLowerCase(), propVal);
	}
}

function ToolbarAPIGetProperty(propName)
{
	switch (propName.toLowerCase())
	{
		default:
			return this._winRef.handleGetProperty(propName.toLowerCase());
	}
}

function ToolbarAPIExecuteMethod(methodName, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
{
	if (typeof(methodName.toLowerCase) == "function")
	{
		switch (methodName.toLowerCase())
		{
			default:
				return this._winRef.handleExecuteMethod(methodName.toLowerCase(), arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
		}
	}
}

function ToolbarAPIPersistData()
{
	this._winRef.persistData();
}

